%% PLOTTING C60 SENSOR'S FREQUENCY RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'drawbacks.csv',...
         };    

[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file
 
 
%% Extracting data
importfile(file);
[raws,columns] = size(data);

time = data(:,1);

VDS = data(:,2);
I_mirr = data(:,4);
V_comp = data(:,6);
V_cap = data(:,8);

figure(1);
p1 = plot(time*1e9,VDS,...                  
         'Color','c','LineWidth',1.5);
% pbaspect([1 1 1]);
xlabel('Time [ns]');
ylabel('V_{DS} [V]');
xticklabels({'0','25','50','75'});
xticks([0 25 50 75]);
xlim([0 75]);
hold on;
grid on;

print -depsc epsFig_drawback_VDS; 


figure(2);
subplot(2,1,1);
p2 = plot(time*1e9,I_mirr,...                  
         'Color','r','LineWidth',1.5);
% pbaspect([1 1 1]);
xlabel('Time [ns]');
ylabel('I_{mirr} [A]');
xticklabels({'0','25','50','75'});
xticks([0 25 50 75]);
xlim([0 75]);
hold on;
grid on;


subplot(2,1,2);
p2 = plot(time*1e9,V_comp,time*1e9,V_cap,...                  
         'LineWidth',1.5);
% pbaspect([1 1 1]);
xlabel('Time [ns]');
ylabel('Voltage [V]');
xticklabels({'0','25','50','75'});
xticks([0 25 50 75]);
xlim([0 75]);
ylim([0 2]);
hold on;
grid on;
legend('Comparator threshold voltage','Voltage across C_{int}');

print -depsc epsFig_drawback_Vcomp_Vcap
